/** @file   HiddenWormAlien.h
 * @brief   Declaration of HiddenWormAlien class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/04/25 18:03:01 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_HiddenWormAlien_H
#define H_WWW_HiddenWormAlien_H

#include "GameObject.h"


namespace WeWantWar {

/** @class  HiddenWormAlien
 * @brief
 * @author  Tomi Lamminsaari
 *
 */
class HiddenWormAlien : public GameObject
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   */
  HiddenWormAlien();

  /** Destructor
   */
  virtual ~HiddenWormAlien();

private:
  HiddenWormAlien( const HiddenWormAlien& aAnother );
  HiddenWormAlien& operator= ( const HiddenWormAlien& aAnother );
public:

  ///
  /// Inherited methods
  /// =================

  /** From GameObject
   */
  virtual void update();
  
  /** From GameObject
   */
  virtual void redraw( RedrawQueue* aQueue );
  
  /** From GameObject
   */
  virtual void makeSound( GameObject::SoundID aSoundId ) const;
  
  /** From GameObject
   */
  virtual bool hitByBullet( Bullet* aBullet );
  
  /** From GameObject
   */
  virtual void kill();
  
  /** From GameObject
   */
  virtual bool reloading() const;
  
  /** From GameObject
   */
  virtual ObjectID::Type objectType() const;

  ///
  /// New public methods
  /// ==================


  ///
  /// Getter methods
  /// ==============


protected:
  ///
  /// Protected interface
  /// ===================
  
  /** Sets correct animation.
   * @param   aAnimId           Id of the animation being activated.
   */
  void setCorrectAnimation( int aAnimId );
  
  /** Attacks.
   */
  void attack();


protected:
  ///
  /// Data members
  /// ============

};

};  // end of namespace

#endif
